//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify certificate
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CA_CERT "ca.cer"
//------------------------------------------------------------------------------
unsigned char Cert[8196];
//------------------------------------------------------------------------------
//       
// :
// 1.   
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY  hKey =0;
 DWORD len;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 if (!CPGetUserKey(hProv,AT_SIGNATURE,&hKey)) {
   printf("CPGetUserKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=sizeof(Cert);
 if (!CPGetKeyParam(hProv,hKey,KP_CERTIFICATE_CA,Cert,&len,0)) {
   printf("CPGetKeyParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 writeFile(CA_CERT,Cert,len);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
